/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8285.DeviceView;

import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8285.DeviceView.Builder;
import ibm.nways.jdm8285.DeviceView.BuilderLike;
import ibm.nways.jdm8285.DeviceView.Chassis;
import ibm.nways.jdm8285.DeviceView.ModuleLike;
import ibm.nways.ras.RAS;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class Chassis8285Expansion
extends Chassis {
    private int offset = 30;
    protected GraphicContainer expansionContainer = new GraphicContainer();
    protected GraphicContainer modulesContainer = new GraphicContainer();

    public void discoverChildren() {
        String string = "discoverChildren";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, this, string);
        }
        BuilderLike builderLike = Builder.getInstance();
        try {
            GenModel genModel = (GenModel)((GenModel)this.jdmBrowser.getModel()).getComponent("ExpansionModules");
            Vector vector = genModel.getRestOfInfo("Panel", "default", null, null);
            if (vector instanceof Vector) {
                if (RAS.isEnabled(19, 6)) {
                    RAS.trace(19, 6, this, string, "Modules found in 8285 extension.");
                }
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    long l = System.currentTimeMillis();
                    ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
                    int n = (Integer)modelInfo.get("Index.SlotIndex");
                    if (n == 1) continue;
                    Serializable serializable = modelInfo.get("Panel.ModuleType");
                    if (RAS.isEnabled(19, 6)) {
                        RAS.trace(19, 6, this, string, "Found module " + serializable + " in slot " + n);
                    }
                    ModuleLike moduleLike = builderLike.buildModule(this.chassisInfo, n, serializable, this.expansionContainer, (GenModel)this.jdmBrowser.getModel());
                    int n2 = 0;
                    n2 = moduleLike.getGrowthDirection() < 0 ? n : n + (moduleLike.getNumberOfSlots() - 1);
                    Point point = this.getModulePosition(n2, moduleLike);
                    moduleLike.setLocation(point);
                    this.add(moduleLike);
                    long l2 = System.currentTimeMillis();
                    if (!RAS.isEnabled(19, 6)) continue;
                    RAS.trace(19, 6, this, string, "Time to build module in slot " + n + "-> " + (l2 - l));
                }
            } else if (RAS.isEnabled(19, 6)) {
                RAS.trace(19, 6, this, string, "Modules not found in 8285 extension.");
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 6, this, string, exception);
        }
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, this, string);
        }
    }

    public void draw() {
        String string = "draw";
        GraphicImage graphicImage = new GraphicImage(this.jdmBrowser.imageFrom((Object)this, "gif/8285_exp_chassis.gif"), new Point(0, 0), 4, null, null);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.jdm8285.DeviceView.GraphicResources");
        try {
            GenModel genModel = (GenModel)this.jdmBrowser.getModel();
            GenModel genModel2 = (GenModel)genModel.getComponent("ExpansionScalars");
            GraphicActionNavigate graphicActionNavigate = new GraphicActionNavigate((GraphicHandler)this.jdmBrowser, new NavigationDestination("ibm.nways.jdm8285.eui.ExpansionPanel", (RemoteModel)genModel2), null);
            graphicImage.setAction((GraphicAction)graphicActionNavigate);
        }
        catch (Exception exception) {
            RAS.logException(19, 6, this, string, exception);
        }
        graphicImage.setFlyOver(new GraphicFlyOver(resourceBundle.getString("8285_exp_chassis")));
        this.expansionContainer.setLocation(0, this.offset);
        this.expansionContainer.add((GraphicComponent)graphicImage);
        this.container.add(this.expansionContainer);
        super.draw();
    }

    public void dispose() {
        String string = "dispose";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, this, string);
        }
        this.expansionContainer.dispose();
        this.expansionContainer = null;
        super.dispose();
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, this, string);
        }
    }

    public Point getModulePosition(int n, ModuleLike moduleLike) {
        return new Point(69, 134 - 36 * (n - 1));
    }
}

